function p = simplexproj(x,delta)
% projection onto n-dimensional simplex set
% Delta = { x : 0 <= x <= 1, sum(x) == 1}
if (nargin < 2)
    delta = 1;
end
x = x ./ delta;
    

n = length(x);
y = sortrows(x,-1);
index = zeros(n,1);

for i = 1:n
    z = y - y(i); 
    index(i) = sum( z(1:i));
end

t = -1;
for i = 2:n
    if (index(i-1) <= 1) && (index(i) >= 1) 
        t = (sum(y(1:i-1)) - 1) / (i-1);
    end
end
if (t == -1)
    t = (sum(y(1:n)) - 1) / n;
end

p = x - t;
p(p < 0) = 0;
p = p .* delta;

return;
